/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.datagen.providers;

import compasses.expandedstorage.impl.datagen.content.ModTags;
import compasses.expandedstorage.impl.item.ChestMinecartItem;
import compasses.expandedstorage.impl.misc.Utils;
import compasses.expandedstorage.impl.registration.ModItems;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class RecipeHelper {
    private final Function<Item, ResourceLocation> itemIdGetter;
    private final TagKey<Item> copperIngots;
    private final TagKey<Item> ironNuggets;
    private final TagKey<Item> ironIngots;
    private final TagKey<Item> goldIngots;
    private final TagKey<Item> diamonds;
    private final TagKey<Item> obsidianBlocks;
    private final TagKey<Item> netheriteIngots;
    private final TagKey<Item> glassBlocks;
    private final TagKey<Item> woodenChests;
    private final TagKey<Item> woodenBarrels;
    private final TagKey<Item> redDyes;
    private final TagKey<Item> whiteDyes;
    private final TagKey<Item> bamboo;

    public RecipeHelper(Function<Item, ResourceLocation> itemIdGetter, TagKey<Item> copperIngots, TagKey<Item> ironNuggets, TagKey<Item> ironIngots, TagKey<Item> goldIngots, TagKey<Item> diamonds, TagKey<Item> obsidianBlocks, TagKey<Item> netheriteIngots, TagKey<Item> woodenChests, TagKey<Item> woodenBarrels, TagKey<Item> glassBlocks, TagKey<Item> redDyes, TagKey<Item> whiteDyes, TagKey<Item> bamboo) {
        this.itemIdGetter = itemIdGetter;
        this.copperIngots = copperIngots;
        this.ironNuggets = ironNuggets;
        this.ironIngots = ironIngots;
        this.goldIngots = goldIngots;
        this.diamonds = diamonds;
        this.obsidianBlocks = obsidianBlocks;
        this.netheriteIngots = netheriteIngots;
        this.woodenChests = woodenChests;
        this.woodenBarrels = woodenBarrels;
        this.glassBlocks = glassBlocks;
        this.redDyes = redDyes;
        this.whiteDyes = whiteDyes;
        this.bamboo = bamboo;
    }

    private void smithingRecipe(Item output, Item base, TagKey<Item> addition, RecipeCategory category, String criterion, Consumer<FinishedRecipe> exporter) {
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_265918_}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{base}), (Ingredient)Ingredient.m_204132_(addition), (RecipeCategory)category, (Item)output).m_266439_(criterion, (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)base)).m_266371_(exporter, this.itemIdGetter.apply(output));
    }

    private ShapedRecipeBuilder shapedRecipe(ItemLike output, RecipeCategory category, int count, String criterion, TagKey<Item> tag) {
        return ShapedRecipeBuilder.m_246608_((RecipeCategory)category, (ItemLike)output, (int)count).m_126132_(criterion, (CriterionTriggerInstance)RecipeProvider.m_206406_(tag));
    }

    private ShapedRecipeBuilder shapedRecipe(ItemLike output, RecipeCategory category, int count, String criterion, Item item) {
        return ShapedRecipeBuilder.m_246608_((RecipeCategory)category, (ItemLike)output, (int)count).m_126132_(criterion, (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)item));
    }

    public void registerRecipes(Consumer<FinishedRecipe> exporter) {
        this.shapedRecipe((ItemLike)ModItems.STORAGE_MUTATOR, RecipeCategory.MISC, 1, "has_chest", ModTags.Items.ES_WOODEN_CHESTS).m_126130_("  C").m_126130_(" S ").m_126130_("S  ").m_206416_(Character.valueOf('C'), ModTags.Items.ES_WOODEN_CHESTS).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42398_).m_176498_(exporter);
        this.offerConversionKitRecipes(exporter);
        this.offerChestRecipes(exporter);
        this.offerChestMinecartRecipes(exporter);
        this.offerOldChestRecipes(exporter);
        this.offerChestToOldChestRecipes(exporter);
        this.offerOldChestToChestRecipes(exporter);
        this.offerBarrelRecipes(exporter);
        this.offerMiniStorageRecipes(exporter);
    }

    private void offerConversionKitRecipes(Consumer<FinishedRecipe> exporter) {
        this.shapedRecipe((ItemLike)ModItems.WOOD_TO_COPPER_CONVERSION_KIT, RecipeCategory.MISC, 1, "has_item", (TagKey<Item>)ItemTags.f_13168_).m_126130_("III").m_126130_("IPI").m_126130_("III").m_206416_(Character.valueOf('I'), this.copperIngots).m_206416_(Character.valueOf('P'), ItemTags.f_13168_).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.WOOD_TO_IRON_CONVERSION_KIT, RecipeCategory.MISC, 1, "has_item", ModItems.WOOD_TO_COPPER_CONVERSION_KIT).m_126130_("NNN").m_126130_("IKI").m_126130_("NNN").m_206416_(Character.valueOf('N'), this.ironNuggets).m_206416_(Character.valueOf('I'), this.ironIngots).m_126127_(Character.valueOf('K'), (ItemLike)ModItems.WOOD_TO_COPPER_CONVERSION_KIT).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.WOOD_TO_GOLD_CONVERSION_KIT, RecipeCategory.MISC, 1, "has_previous_kit", ModItems.WOOD_TO_IRON_CONVERSION_KIT).m_126130_("GGG").m_126130_("GKG").m_126130_("GGG").m_206416_(Character.valueOf('G'), this.goldIngots).m_126127_(Character.valueOf('K'), (ItemLike)ModItems.WOOD_TO_IRON_CONVERSION_KIT).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.WOOD_TO_DIAMOND_CONVERSION_KIT, RecipeCategory.MISC, 1, "has_previous_kit", ModItems.WOOD_TO_GOLD_CONVERSION_KIT).m_126130_("GGG").m_126130_("DKD").m_126130_("GGG").m_206416_(Character.valueOf('G'), this.glassBlocks).m_206416_(Character.valueOf('D'), this.diamonds).m_126127_(Character.valueOf('K'), (ItemLike)ModItems.WOOD_TO_GOLD_CONVERSION_KIT).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.WOOD_TO_OBSIDIAN_CONVERSION_KIT, RecipeCategory.MISC, 1, "has_previous_kit", ModItems.WOOD_TO_DIAMOND_CONVERSION_KIT).m_126130_("OOO").m_126130_("OKO").m_126130_("OOO").m_206416_(Character.valueOf('O'), this.obsidianBlocks).m_126127_(Character.valueOf('K'), (ItemLike)ModItems.WOOD_TO_DIAMOND_CONVERSION_KIT).m_176498_(exporter);
        this.smithingRecipe(ModItems.WOOD_TO_NETHERITE_CONVERSION_KIT, ModItems.WOOD_TO_OBSIDIAN_CONVERSION_KIT, this.netheriteIngots, RecipeCategory.MISC, "has_previous_kit", exporter);
        this.shapedRecipe((ItemLike)ModItems.COPPER_TO_IRON_CONVERSION_KIT, RecipeCategory.MISC, 1, "has_item", this.copperIngots).m_126130_("NNN").m_126130_("ICI").m_126130_("NNN").m_206416_(Character.valueOf('N'), this.ironNuggets).m_206416_(Character.valueOf('I'), this.ironIngots).m_206416_(Character.valueOf('C'), this.copperIngots).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.COPPER_TO_GOLD_CONVERSION_KIT, RecipeCategory.MISC, 1, "has_item", ModItems.COPPER_TO_IRON_CONVERSION_KIT).m_126130_("GGG").m_126130_("GKG").m_126130_("GGG").m_206416_(Character.valueOf('G'), this.goldIngots).m_126127_(Character.valueOf('K'), (ItemLike)ModItems.COPPER_TO_IRON_CONVERSION_KIT).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.COPPER_TO_DIAMOND_CONVERSION_KIT, RecipeCategory.MISC, 1, "has_previous_kit", ModItems.COPPER_TO_GOLD_CONVERSION_KIT).m_126130_("GGG").m_126130_("DKD").m_126130_("GGG").m_206416_(Character.valueOf('G'), this.glassBlocks).m_206416_(Character.valueOf('D'), this.diamonds).m_126127_(Character.valueOf('K'), (ItemLike)ModItems.COPPER_TO_GOLD_CONVERSION_KIT).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.COPPER_TO_OBSIDIAN_CONVERSION_KIT, RecipeCategory.MISC, 1, "has_previous_kit", ModItems.COPPER_TO_DIAMOND_CONVERSION_KIT).m_126130_("OOO").m_126130_("OKO").m_126130_("OOO").m_206416_(Character.valueOf('O'), this.obsidianBlocks).m_126127_(Character.valueOf('K'), (ItemLike)ModItems.COPPER_TO_DIAMOND_CONVERSION_KIT).m_176498_(exporter);
        this.smithingRecipe(ModItems.COPPER_TO_NETHERITE_CONVERSION_KIT, ModItems.COPPER_TO_OBSIDIAN_CONVERSION_KIT, this.netheriteIngots, RecipeCategory.MISC, "has_previous_kit", exporter);
        this.shapedRecipe((ItemLike)ModItems.IRON_TO_GOLD_CONVERSION_KIT, RecipeCategory.MISC, 1, "has_item", this.ironIngots).m_126130_("GGG").m_126130_("GIG").m_126130_("GGG").m_206416_(Character.valueOf('G'), this.goldIngots).m_206416_(Character.valueOf('I'), this.ironIngots).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.IRON_TO_DIAMOND_CONVERSION_KIT, RecipeCategory.MISC, 1, "has_previous_kit", ModItems.IRON_TO_GOLD_CONVERSION_KIT).m_126130_("GGG").m_126130_("DKD").m_126130_("GGG").m_206416_(Character.valueOf('G'), this.glassBlocks).m_206416_(Character.valueOf('D'), this.diamonds).m_126127_(Character.valueOf('K'), (ItemLike)ModItems.IRON_TO_GOLD_CONVERSION_KIT).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.IRON_TO_OBSIDIAN_CONVERSION_KIT, RecipeCategory.MISC, 1, "has_previous_kit", ModItems.IRON_TO_DIAMOND_CONVERSION_KIT).m_126130_("OOO").m_126130_("OKO").m_126130_("OOO").m_206416_(Character.valueOf('O'), this.obsidianBlocks).m_126127_(Character.valueOf('K'), (ItemLike)ModItems.IRON_TO_DIAMOND_CONVERSION_KIT).m_176498_(exporter);
        this.smithingRecipe(ModItems.IRON_TO_NETHERITE_CONVERSION_KIT, ModItems.IRON_TO_OBSIDIAN_CONVERSION_KIT, this.netheriteIngots, RecipeCategory.MISC, "has_previous_kit", exporter);
        this.shapedRecipe((ItemLike)ModItems.GOLD_TO_DIAMOND_CONVERSION_KIT, RecipeCategory.MISC, 1, "has_item", this.goldIngots).m_126130_("GGG").m_126130_("DID").m_126130_("GGG").m_206416_(Character.valueOf('G'), this.glassBlocks).m_206416_(Character.valueOf('D'), this.diamonds).m_206416_(Character.valueOf('I'), this.goldIngots).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.GOLD_TO_OBSIDIAN_CONVERSION_KIT, RecipeCategory.MISC, 1, "has_previous_kit", ModItems.GOLD_TO_DIAMOND_CONVERSION_KIT).m_126130_("OOO").m_126130_("OKO").m_126130_("OOO").m_206416_(Character.valueOf('O'), this.obsidianBlocks).m_126127_(Character.valueOf('K'), (ItemLike)ModItems.GOLD_TO_DIAMOND_CONVERSION_KIT).m_176498_(exporter);
        this.smithingRecipe(ModItems.GOLD_TO_NETHERITE_CONVERSION_KIT, ModItems.GOLD_TO_OBSIDIAN_CONVERSION_KIT, this.netheriteIngots, RecipeCategory.MISC, "has_previous_kit", exporter);
        this.shapedRecipe((ItemLike)ModItems.DIAMOND_TO_OBSIDIAN_CONVERSION_KIT, RecipeCategory.MISC, 1, "has_item", this.diamonds).m_126130_("OOO").m_126130_("ODO").m_126130_("OOO").m_206416_(Character.valueOf('O'), this.obsidianBlocks).m_206416_(Character.valueOf('D'), this.diamonds).m_176498_(exporter);
        this.smithingRecipe(ModItems.DIAMOND_TO_NETHERITE_CONVERSION_KIT, ModItems.DIAMOND_TO_OBSIDIAN_CONVERSION_KIT, this.netheriteIngots, RecipeCategory.MISC, "has_previous_kit", exporter);
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)Ingredient.m_151265_(), (Ingredient)Ingredient.m_204132_(this.obsidianBlocks), (Ingredient)Ingredient.m_204132_(this.netheriteIngots), (RecipeCategory)RecipeCategory.MISC, (Item)ModItems.OBSIDIAN_TO_NETHERITE_CONVERSION_KIT).m_266439_("has_item", (CriterionTriggerInstance)RecipeProvider.m_206406_(this.obsidianBlocks)).m_266371_(exporter, this.itemIdGetter.apply(ModItems.OBSIDIAN_TO_NETHERITE_CONVERSION_KIT));
    }

    private void offerChestRecipes(Consumer<FinishedRecipe> exporter) {
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ModItems.WOOD_CHEST).m_126209_((ItemLike)Items.f_42009_).m_126145_(this.id((ItemLike)ModItems.WOOD_CHEST)).m_126132_("has_previous_block", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)Items.f_42009_)).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.PUMPKIN_CHEST, RecipeCategory.MISC, 1, "has_previous_block", this.woodenChests).m_126130_("SSS").m_126130_("SBS").m_126130_("SSS").m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42577_).m_206416_(Character.valueOf('B'), this.woodenChests).m_126145_(this.id((ItemLike)ModItems.PUMPKIN_CHEST)).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.PRESENT, RecipeCategory.MISC, 1, "has_previous_block", this.woodenChests).m_126130_(" B ").m_126130_("RCW").m_126130_(" S ").m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42780_).m_206416_(Character.valueOf('R'), this.redDyes).m_206416_(Character.valueOf('C'), this.woodenChests).m_206416_(Character.valueOf('W'), this.whiteDyes).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42800_).m_126145_(this.id((ItemLike)ModItems.PRESENT)).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.BAMBOO_CHEST, RecipeCategory.MISC, 1, "has_previous_block", this.woodenChests).m_126130_("BBB").m_126130_("BCB").m_126130_("BBB").m_206416_(Character.valueOf('B'), this.bamboo).m_206416_(Character.valueOf('C'), this.woodenChests).m_126145_(this.id((ItemLike)ModItems.BAMBOO_CHEST)).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.MOSS_CHEST, RecipeCategory.MISC, 1, "has_previous_block", this.woodenChests).m_126130_("BBB").m_126130_("BCB").m_126130_("BBB").m_126127_(Character.valueOf('B'), (ItemLike)Blocks.f_152544_).m_206416_(Character.valueOf('C'), this.woodenChests).m_126145_(this.id((ItemLike)ModItems.BAMBOO_CHEST)).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.IRON_CHEST, RecipeCategory.MISC, 1, "has_previous_block", ModTags.Items.ES_WOODEN_CHESTS).m_126130_("III").m_126130_("IBI").m_126130_("III").m_206416_(Character.valueOf('I'), this.ironIngots).m_206416_(Character.valueOf('B'), ModTags.Items.ES_WOODEN_CHESTS).m_126145_(this.id((ItemLike)ModItems.IRON_CHEST)).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.GOLD_CHEST, RecipeCategory.MISC, 1, "has_previous_block", (Item)ModItems.IRON_CHEST).m_126130_("GGG").m_126130_("GBG").m_126130_("GGG").m_206416_(Character.valueOf('G'), this.goldIngots).m_126127_(Character.valueOf('B'), (ItemLike)ModItems.IRON_CHEST).m_126145_(this.id((ItemLike)ModItems.GOLD_CHEST)).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.DIAMOND_CHEST, RecipeCategory.MISC, 1, "has_previous_block", (Item)ModItems.GOLD_CHEST).m_126130_("GGG").m_126130_("DBD").m_126130_("GGG").m_206416_(Character.valueOf('G'), this.glassBlocks).m_206416_(Character.valueOf('D'), this.diamonds).m_126127_(Character.valueOf('B'), (ItemLike)ModItems.GOLD_CHEST).m_126145_(this.id((ItemLike)ModItems.DIAMOND_CHEST)).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.OBSIDIAN_CHEST, RecipeCategory.MISC, 1, "has_previous_block", (Item)ModItems.DIAMOND_CHEST).m_126130_("OOO").m_126130_("OBO").m_126130_("OOO").m_206416_(Character.valueOf('O'), this.obsidianBlocks).m_126127_(Character.valueOf('B'), (ItemLike)ModItems.DIAMOND_CHEST).m_126145_(this.id((ItemLike)ModItems.OBSIDIAN_CHEST)).m_176498_(exporter);
        this.smithingRecipe((Item)ModItems.NETHERITE_CHEST, (Item)ModItems.OBSIDIAN_CHEST, this.netheriteIngots, RecipeCategory.MISC, "has_previous_block", exporter);
    }

    private void offerChestMinecartRecipes(Consumer<FinishedRecipe> exporter) {
        this.cartRecipe(ModItems.WOOD_CHEST, ModItems.WOOD_CHEST_MINECART, exporter);
        this.cartRecipe(ModItems.PUMPKIN_CHEST, ModItems.PUMPKIN_CHEST_MINECART, exporter);
        this.cartRecipe(ModItems.PRESENT, ModItems.PRESENT_MINECART, exporter);
        this.cartRecipe(ModItems.BAMBOO_CHEST, ModItems.BAMBOO_CHEST_MINECART, exporter);
        this.cartRecipe(ModItems.IRON_CHEST, ModItems.IRON_CHEST_MINECART, exporter);
        this.cartRecipe(ModItems.GOLD_CHEST, ModItems.GOLD_CHEST_MINECART, exporter);
        this.cartRecipe(ModItems.DIAMOND_CHEST, ModItems.DIAMOND_CHEST_MINECART, exporter);
        this.cartRecipe(ModItems.OBSIDIAN_CHEST, ModItems.OBSIDIAN_CHEST_MINECART, exporter);
        this.cartRecipe(ModItems.NETHERITE_CHEST, ModItems.NETHERITE_CHEST_MINECART, exporter);
    }

    private void cartRecipe(BlockItem chest, ChestMinecartItem cart, Consumer<FinishedRecipe> exporter) {
        this.shapedRecipe((ItemLike)cart, RecipeCategory.MISC, 1, "has_chest", (Item)chest).m_126130_("C").m_126130_("M").m_126127_(Character.valueOf('C'), (ItemLike)chest).m_126127_(Character.valueOf('M'), (ItemLike)Items.f_42449_).m_176498_(exporter);
    }

    private void offerOldChestRecipes(Consumer<FinishedRecipe> exporter) {
        this.shapedRecipe((ItemLike)ModItems.OLD_IRON_CHEST, RecipeCategory.MISC, 1, "has_previous_block", (Item)ModItems.OLD_WOOD_CHEST).m_126130_("III").m_126130_("IBI").m_126130_("III").m_206416_(Character.valueOf('I'), this.ironIngots).m_126127_(Character.valueOf('B'), (ItemLike)ModItems.OLD_WOOD_CHEST).m_126145_(this.id((ItemLike)ModItems.OLD_IRON_CHEST)).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.OLD_GOLD_CHEST, RecipeCategory.MISC, 1, "has_previous_block", (Item)ModItems.OLD_IRON_CHEST).m_126130_("GGG").m_126130_("GBG").m_126130_("GGG").m_206416_(Character.valueOf('G'), this.goldIngots).m_126127_(Character.valueOf('B'), (ItemLike)ModItems.OLD_IRON_CHEST).m_126145_(this.id((ItemLike)ModItems.OLD_GOLD_CHEST)).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.OLD_DIAMOND_CHEST, RecipeCategory.MISC, 1, "has_previous_block", (Item)ModItems.OLD_GOLD_CHEST).m_126130_("GGG").m_126130_("DBD").m_126130_("GGG").m_206416_(Character.valueOf('G'), this.glassBlocks).m_206416_(Character.valueOf('D'), this.diamonds).m_126127_(Character.valueOf('B'), (ItemLike)ModItems.OLD_GOLD_CHEST).m_126145_(this.id((ItemLike)ModItems.OLD_DIAMOND_CHEST)).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.OLD_OBSIDIAN_CHEST, RecipeCategory.MISC, 1, "has_previous_block", (Item)ModItems.OLD_DIAMOND_CHEST).m_126130_("OOO").m_126130_("OBO").m_126130_("OOO").m_206416_(Character.valueOf('O'), this.obsidianBlocks).m_126127_(Character.valueOf('B'), (ItemLike)ModItems.OLD_DIAMOND_CHEST).m_126145_(this.id((ItemLike)ModItems.OLD_OBSIDIAN_CHEST)).m_176498_(exporter);
        this.smithingRecipe((Item)ModItems.OLD_NETHERITE_CHEST, (Item)ModItems.OLD_OBSIDIAN_CHEST, this.netheriteIngots, RecipeCategory.MISC, "has_previous_block", exporter);
    }

    private void offerChestToOldChestRecipes(Consumer<FinishedRecipe> exporter) {
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ModItems.OLD_WOOD_CHEST).m_126209_((ItemLike)ModItems.WOOD_CHEST).m_126145_(this.id((ItemLike)ModItems.OLD_WOOD_CHEST)).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)ModItems.WOOD_CHEST)).m_126140_(exporter, Utils.id("wood_to_old_wood_chest"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ModItems.OLD_IRON_CHEST).m_126209_((ItemLike)ModItems.IRON_CHEST).m_126145_(this.id((ItemLike)ModItems.OLD_IRON_CHEST)).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)ModItems.IRON_CHEST)).m_126140_(exporter, Utils.id("iron_to_old_iron_chest"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ModItems.OLD_GOLD_CHEST).m_126209_((ItemLike)ModItems.GOLD_CHEST).m_126145_(this.id((ItemLike)ModItems.OLD_GOLD_CHEST)).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)ModItems.GOLD_CHEST)).m_126140_(exporter, Utils.id("gold_to_old_gold_chest"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ModItems.OLD_DIAMOND_CHEST).m_126209_((ItemLike)ModItems.DIAMOND_CHEST).m_126145_(this.id((ItemLike)ModItems.OLD_DIAMOND_CHEST)).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)ModItems.DIAMOND_CHEST)).m_126140_(exporter, Utils.id("diamond_to_old_diamond_chest"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ModItems.OLD_OBSIDIAN_CHEST).m_126209_((ItemLike)ModItems.OBSIDIAN_CHEST).m_126145_(this.id((ItemLike)ModItems.OLD_OBSIDIAN_CHEST)).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)ModItems.OBSIDIAN_CHEST)).m_126140_(exporter, Utils.id("obsidian_to_old_obsidian_chest"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ModItems.OLD_NETHERITE_CHEST).m_126209_((ItemLike)ModItems.NETHERITE_CHEST).m_126145_(this.id((ItemLike)ModItems.OLD_NETHERITE_CHEST)).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)ModItems.NETHERITE_CHEST)).m_126140_(exporter, Utils.id("netherite_to_old_netherite_chest"));
    }

    private void offerOldChestToChestRecipes(Consumer<FinishedRecipe> exporter) {
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ModItems.WOOD_CHEST).m_126209_((ItemLike)ModItems.OLD_WOOD_CHEST).m_126145_(this.id((ItemLike)ModItems.WOOD_CHEST)).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)ModItems.OLD_WOOD_CHEST)).m_126140_(exporter, Utils.id("old_wood_to_wood_chest"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ModItems.IRON_CHEST).m_126209_((ItemLike)ModItems.OLD_IRON_CHEST).m_126145_(this.id((ItemLike)ModItems.IRON_CHEST)).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)ModItems.OLD_IRON_CHEST)).m_126140_(exporter, Utils.id("old_iron_to_iron_chest"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ModItems.GOLD_CHEST).m_126209_((ItemLike)ModItems.OLD_GOLD_CHEST).m_126145_(this.id((ItemLike)ModItems.GOLD_CHEST)).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)ModItems.OLD_GOLD_CHEST)).m_126140_(exporter, Utils.id("old_gold_to_gold_chest"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ModItems.DIAMOND_CHEST).m_126209_((ItemLike)ModItems.OLD_DIAMOND_CHEST).m_126145_(this.id((ItemLike)ModItems.DIAMOND_CHEST)).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)ModItems.OLD_DIAMOND_CHEST)).m_126140_(exporter, Utils.id("old_diamond_to_diamond_chest"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ModItems.OBSIDIAN_CHEST).m_126209_((ItemLike)ModItems.OLD_OBSIDIAN_CHEST).m_126145_(this.id((ItemLike)ModItems.OBSIDIAN_CHEST)).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)ModItems.OLD_OBSIDIAN_CHEST)).m_126140_(exporter, Utils.id("old_obsidian_to_obsidian_chest"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ModItems.NETHERITE_CHEST).m_126209_((ItemLike)ModItems.OLD_NETHERITE_CHEST).m_126145_(this.id((ItemLike)ModItems.NETHERITE_CHEST)).m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)ModItems.OLD_NETHERITE_CHEST)).m_126140_(exporter, Utils.id("old_netherite_to_netherite_chest"));
    }

    private void offerBarrelRecipes(Consumer<FinishedRecipe> exporter) {
        this.shapedRecipe((ItemLike)ModItems.COPPER_BARREL, RecipeCategory.MISC, 1, "has_previous_block", this.woodenBarrels).m_126130_("III").m_126130_("IBI").m_126130_("III").m_206416_(Character.valueOf('I'), this.copperIngots).m_206416_(Character.valueOf('B'), this.woodenBarrels).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.IRON_BARREL, RecipeCategory.MISC, 1, "has_previous_block", (Item)ModItems.COPPER_BARREL).m_126130_("NNN").m_126130_("IBI").m_126130_("NNN").m_206416_(Character.valueOf('N'), this.ironNuggets).m_206416_(Character.valueOf('I'), this.ironIngots).m_126127_(Character.valueOf('B'), (ItemLike)ModItems.COPPER_BARREL).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.GOLD_BARREL, RecipeCategory.MISC, 1, "has_previous_block", (Item)ModItems.IRON_BARREL).m_126130_("GGG").m_126130_("GBG").m_126130_("GGG").m_206416_(Character.valueOf('G'), this.goldIngots).m_126127_(Character.valueOf('B'), (ItemLike)ModItems.IRON_BARREL).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.DIAMOND_BARREL, RecipeCategory.MISC, 1, "has_previous_block", (Item)ModItems.GOLD_BARREL).m_126130_("GGG").m_126130_("DBD").m_126130_("GGG").m_206416_(Character.valueOf('G'), this.glassBlocks).m_206416_(Character.valueOf('D'), this.diamonds).m_126127_(Character.valueOf('B'), (ItemLike)ModItems.GOLD_BARREL).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.OBSIDIAN_BARREL, RecipeCategory.MISC, 1, "has_previous_block", (Item)ModItems.DIAMOND_BARREL).m_126130_("OOO").m_126130_("OBO").m_126130_("OOO").m_206416_(Character.valueOf('O'), this.obsidianBlocks).m_126127_(Character.valueOf('B'), (ItemLike)ModItems.DIAMOND_BARREL).m_176498_(exporter);
        this.smithingRecipe((Item)ModItems.NETHERITE_BARREL, (Item)ModItems.OBSIDIAN_BARREL, this.netheriteIngots, RecipeCategory.MISC, "has_previous_block", exporter);
    }

    private void offerMiniStorageRecipes(Consumer<FinishedRecipe> exporter) {
        this.shapedRecipe((ItemLike)ModItems.VANILLA_WOOD_MINI_CHEST, RecipeCategory.MISC, 4, "has_item", Items.f_42009_).m_126130_(" P ").m_126130_("PBP").m_126130_(" P ").m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42009_).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.WOOD_MINI_CHEST, RecipeCategory.MISC, 4, "has_item", (Item)ModItems.WOOD_CHEST).m_126130_(" P ").m_126130_("PBP").m_126130_(" P ").m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_126127_(Character.valueOf('B'), (ItemLike)ModItems.WOOD_CHEST).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.PUMPKIN_MINI_CHEST, RecipeCategory.MISC, 4, "has_item", (Item)ModItems.PUMPKIN_CHEST).m_126130_(" P ").m_126130_("PBP").m_126130_(" P ").m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_126127_(Character.valueOf('B'), (ItemLike)ModItems.PUMPKIN_CHEST).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.RED_MINI_PRESENT, RecipeCategory.MISC, 4, "has_item", (Item)ModItems.PRESENT).m_126130_(" P ").m_126130_("PBP").m_126130_(" P ").m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_126127_(Character.valueOf('B'), (ItemLike)ModItems.PRESENT).m_126145_(this.id((ItemLike)ModItems.RED_MINI_PRESENT)).m_176498_(exporter);
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ModItems.WHITE_MINI_PRESENT).m_126209_((ItemLike)ModItems.RED_MINI_PRESENT).m_126132_("has_previous_block", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)ModItems.RED_MINI_PRESENT)).m_176498_(exporter);
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ModItems.CANDY_CANE_MINI_PRESENT).m_126209_((ItemLike)ModItems.WHITE_MINI_PRESENT).m_126132_("has_previous_block", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)ModItems.WHITE_MINI_PRESENT)).m_176498_(exporter);
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ModItems.GREEN_MINI_PRESENT).m_126209_((ItemLike)ModItems.CANDY_CANE_MINI_PRESENT).m_126132_("has_previous_block", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)ModItems.CANDY_CANE_MINI_PRESENT)).m_176498_(exporter);
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ModItems.RED_MINI_PRESENT).m_126209_((ItemLike)ModItems.GREEN_MINI_PRESENT).m_126145_(this.id((ItemLike)ModItems.RED_MINI_PRESENT)).m_126132_("has_previous_block", (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)ModItems.GREEN_MINI_PRESENT)).m_176500_(exporter, "expandedstorage:red_mini_present_cycle");
        this.shapedRecipe((ItemLike)ModItems.IRON_MINI_CHEST, RecipeCategory.MISC, 8, "has_item", (Item)ModItems.WOOD_CHEST).m_126130_(" I ").m_126130_("PBP").m_126130_(" P ").m_126127_(Character.valueOf('I'), (ItemLike)Items.f_42416_).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_126127_(Character.valueOf('B'), (ItemLike)ModItems.WOOD_CHEST).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.GOLD_MINI_CHEST, RecipeCategory.MISC, 8, "has_item", (Item)ModItems.WOOD_CHEST).m_126130_(" I ").m_126130_("PBP").m_126130_(" P ").m_126127_(Character.valueOf('I'), (ItemLike)Items.f_42417_).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_126127_(Character.valueOf('B'), (ItemLike)ModItems.WOOD_CHEST).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.DIAMOND_MINI_CHEST, RecipeCategory.MISC, 8, "has_item", (Item)ModItems.WOOD_CHEST).m_126130_(" I ").m_126130_("PBP").m_126130_(" P ").m_126127_(Character.valueOf('I'), (ItemLike)Items.f_42415_).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_126127_(Character.valueOf('B'), (ItemLike)ModItems.WOOD_CHEST).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.OBSIDIAN_MINI_CHEST, RecipeCategory.MISC, 8, "has_item", (Item)ModItems.WOOD_CHEST).m_126130_(" I ").m_126130_("PBP").m_126130_(" P ").m_126127_(Character.valueOf('I'), (ItemLike)Items.f_41999_).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_126127_(Character.valueOf('B'), (ItemLike)ModItems.WOOD_CHEST).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.NETHERITE_MINI_CHEST, RecipeCategory.MISC, 8, "has_item", (Item)ModItems.WOOD_CHEST).m_126130_(" I ").m_126130_("PBP").m_126130_(" P ").m_126127_(Character.valueOf('I'), (ItemLike)Items.f_42418_).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_126127_(Character.valueOf('B'), (ItemLike)ModItems.WOOD_CHEST).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.MINI_BARREL, RecipeCategory.MISC, 4, "has_item", this.woodenBarrels).m_126130_(" P ").m_126130_("PBP").m_126130_(" P ").m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_206416_(Character.valueOf('B'), this.woodenBarrels).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.COPPER_MINI_BARREL, RecipeCategory.MISC, 8, "has_item", this.woodenBarrels).m_126130_(" I ").m_126130_("PBP").m_126130_(" P ").m_126127_(Character.valueOf('I'), (ItemLike)Items.f_151052_).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_206416_(Character.valueOf('B'), this.woodenBarrels).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.IRON_MINI_BARREL, RecipeCategory.MISC, 8, "has_item", this.woodenBarrels).m_126130_(" I ").m_126130_("PBP").m_126130_(" P ").m_126127_(Character.valueOf('I'), (ItemLike)Items.f_42416_).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_206416_(Character.valueOf('B'), this.woodenBarrels).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.GOLD_MINI_BARREL, RecipeCategory.MISC, 8, "has_item", this.woodenBarrels).m_126130_(" I ").m_126130_("PBP").m_126130_(" P ").m_126127_(Character.valueOf('I'), (ItemLike)Items.f_42417_).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_206416_(Character.valueOf('B'), this.woodenBarrels).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.DIAMOND_MINI_BARREL, RecipeCategory.MISC, 8, "has_item", this.woodenBarrels).m_126130_(" I ").m_126130_("PBP").m_126130_(" P ").m_126127_(Character.valueOf('I'), (ItemLike)Items.f_42415_).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_206416_(Character.valueOf('B'), this.woodenBarrels).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.OBSIDIAN_MINI_BARREL, RecipeCategory.MISC, 8, "has_item", this.woodenBarrels).m_126130_(" I ").m_126130_("PBP").m_126130_(" P ").m_126127_(Character.valueOf('I'), (ItemLike)Items.f_41999_).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_206416_(Character.valueOf('B'), this.woodenBarrels).m_176498_(exporter);
        this.shapedRecipe((ItemLike)ModItems.NETHERITE_MINI_BARREL, RecipeCategory.MISC, 8, "has_item", this.woodenBarrels).m_126130_(" I ").m_126130_("PBP").m_126130_(" P ").m_126127_(Character.valueOf('I'), (ItemLike)Items.f_42418_).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_206416_(Character.valueOf('B'), this.woodenBarrels).m_176498_(exporter);
    }

    private String id(ItemLike like) {
        return this.itemIdGetter.apply(like.m_5456_()).toString();
    }

    private static class Criterions {
        public static final String HAS_ITEM = "has_item";
        private static final String HAS_PREVIOUS_KIT = "has_previous_kit";
        private static final String HAS_PREVIOUS_BLOCK = "has_previous_block";

        private Criterions() {
        }
    }
}

